clc, clear

LibO = myOutputFile;
LibI = myInterfacciaDAQ;
LibT = myTdmsReader;
Zero = [2.872748438 -0.088105225];

%%
% REAR
% d/L = 50% n600: (37) (77) (87)
% d/L = 50% n800: (39) (79) (89)

% FRONT
% d/L =-50% n600: (47) (67) (57)
% d/L =-50% n800: (49) (69) (59)

ss = cell(5,1);
for K = 1:5  %caso isolato, caso con platooning, costant, sine, 2sine
    ss{K} = LibO.txt2struct([],[],"Scegli file n°"+K);
end

%%
n = 800;

f = figure('name',ss{1}.note,'Color','w');
maxF = 100;

mm = [6,9,16];
for K = 1:5
    subplot(1,5,K)
    [smi, tmi, ~] = LibO.extractFromFile( ss{K}.mics );
    switch K
        case 1  %isolated
            if n==600
            ok = (tmi>=60) & (tmi<=120);
            elseif n==800
            ok = (tmi>=180) & (tmi<=240);
            end
            smi = smi(ok, mm(2));
            tVet = tmi(ok);
        case 2  %platoon
            if n==600
            ok = (tmi>=60) & (tmi<=120);
            elseif n==800
            ok = (tmi>=180) & (tmi<=240);
            end
            smi = smi(ok, mm(2));
            tVet = tmi(ok);
        case {3,4,5}
            ok = (tmi>=25) & (tmi<=50);
            smi=smi(ok,mm(2));
            tVet = tmi(ok);
    end
    filterMic = 1;  %(0) no filter, (1) yes filter
    
    if filterMic
        windowCoeff = load('secondo_grup.mat').G2;
        windowCoeff(:,1:8) = load('primo_grup.mat').G1;
        smi = smi - mean(smi);
        for i=1:size(smi,2)
            smi(:,i) = filter( windowCoeff(:,i),1, smi(:,i) ) * 10;
        end
    end
    
    [wt,fr,coi] = cwt(smi,nnz(tmi<1));
    pcolor(tVet'-tVet(1),fr(fr<=maxF),abs(wt(fr<=maxF,:)));
    shading interp; hold on
    colormap('jet')
     
    switch K
        case 1
            title('ISOLATED Truck')
        case 2
            title('PLATOON Test')
        case 3
            title({'PLATOON + FORCING';'(Constant Signal)'})
        case 4
            title({'PLATOON + FORCING';'(Sinusoidal Signal)'})
        case 5
            title({'PLATOON + FORCING';'(Double Sine Signal)'})
    end
    
    maxMagnitude(K)=max(abs(wt(fr<=maxF,:)),[],'all');
    
    % caxis([0 10])
    
    co=colorbar;  
    if K==5
        co.Label.String = 'Magnitude';
    end
    ylim([0 60]);
    xlim([0 25]);
    xlabel('Time [s]')
    if K~=1
       yticks([])
    else
       ylabel({'Side Microphone Pressure';'Wavelet Transform';'Frequency [Hz]'})
    end
    drawnow
    
end

%%
autofit = true;
switch autofit
    case 1
        subplot(1,5,1)
        colormap(gca,'pink')
        caxis([0 max(maxMagnitude(1:2))])
        %caxis([0 max(maxMagnitude(3:5))])
        subplot(1,5,2)
        colormap(gca,'pink')
        caxis([0 max(maxMagnitude(1:2))])
        %caxis([0 max(maxMagnitude(3:5))])
        
        subplot(1,5,3)
        colormap(gca,'jet')
        caxis([0 max(maxMagnitude(3:5))])
        subplot(1,5,4)
        colormap(gca,'jet')
        caxis([0 max(maxMagnitude(3:5))])
        subplot(1,5,5)
        colormap(gca,'jet')
        caxis([0 max(maxMagnitude(3:5))])
        
    case 0
end

%%
for K=1:5
   subplot(1,5,K)
   set(gca,'YScale','log')
end



















